import zipfile

jar_path = "1.16/1.16.jar"

try:
    with zipfile.ZipFile(jar_path, 'r') as zf:
        # 查找所有.class文件
        class_files = [f for f in zf.namelist() if f.endswith('.class')]
        print(f"Found {len(class_files)} class files")
        
        # 查找包含Main的类文件
        main_classes = [f for f in class_files if 'Main' in f]
        print("\nClasses containing 'Main':")
        for cls in main_classes:
            print(cls)
        
        # 查找client目录下的类文件
        client_classes = [f for f in class_files if 'client' in f]
        print(f"\nFound {len(client_classes)} client class files")
        if client_classes:
            print("First 5 client classes:")
            for cls in client_classes[:5]:
                print(cls)
        
        # 尝试从manifest中获取主类
        if 'META-INF/MANIFEST.MF' in zf.namelist():
            manifest = zf.read('META-INF/MANIFEST.MF').decode('utf-8')
            print("\n--- Manifest Info ---")
            for line in manifest.splitlines():
                if 'Main-Class' in line:
                    print(f"Main-Class: {line.split(': ')[1].strip()}")
                    break
            
            # 检查Main-Class指定的类是否存在
            for line in manifest.splitlines():
                if 'Main-Class' in line:
                    main_class = line.split(': ')[1].strip()
                    class_file = main_class.replace('.', '/') + '.class'
                    print(f"\nChecking if {class_file} exists:")
                    print(class_file in zf.namelist())
                    break
                    
except Exception as e:
    print(f"Error: {e}")
